import requests
import json
from datetime import datetime


class QuickBooksDebug:
    def __init__(self, access_token, realm_id):
        self.access_token = access_token
        self.realm_id = realm_id
        self.base_url = "https://sandbox-quickbooks.api.intuit.com/v3"

    def test_authentication(self):
        """Test authentication and connection to QuickBooks"""
        print("🔍 Testing QuickBooks Authentication...")
        print(f"Realm ID: {self.realm_id}")
        print(f"Access Token: {self.access_token[:20]}...")

        # Test 1: Basic company info
        headers = {
            'Authorization': f'Bearer {self.access_token}',
            'Accept': 'application/json'
        }

        url = f"{self.base_url}/company/{self.realm_id}/companyinfo/{self.realm_id}"

        try:
            response = requests.get(url, headers=headers, timeout=30)
            print(f"📡 API Response Status: {response.status_code}")
            print(f"📡 Response Headers: {dict(response.headers)}")

            if response.status_code == 200:
                content_type = response.headers.get('content-type', '')
                if 'application/json' in content_type:
                    data = response.json()
                    print("✅ Authentication SUCCESSFUL!")
                    print(f"🏢 Company: {data.get('CompanyInfo', {}).get('CompanyName', 'Unknown')}")
                    return True, "Authentication successful"
                else:
                    # Handle XML response (error)
                    print(f"❌ Unexpected response type: {content_type}")
                    print(f"📄 Response content: {response.text[:500]}")
                    return False, f"Unexpected response type: {content_type}"
            else:
                print(f"❌ API Error: {response.status_code}")
                print(f"📄 Error response: {response.text[:500]}")
                return False, f"API Error: {response.status_code}"

        except Exception as e:
            print(f"❌ Request failed: {str(e)}")
            return False, f"Request failed: {str(e)}"

    def check_token_validity(self):
        """Check if the access token is valid"""
        print("\n🔐 Checking token validity...")

        headers = {
            'Authorization': f'Bearer {self.access_token}',
            'Accept': 'application/json'
        }

        # Simple query to test token
        url = f"{self.base_url}/company/{self.realm_id}/query?query=SELECT COUNT(*) FROM Customer"

        try:
            response = requests.get(url, headers=headers, timeout=30)
            print(f"📡 Query test status: {response.status_code}")

            if response.status_code == 200:
                print("✅ Token is VALID")
                return True
            else:
                print(f"❌ Token validation failed: {response.status_code}")
                print(f"📄 Response: {response.text[:200]}")
                return False

        except Exception as e:
            print(f"❌ Token check failed: {str(e)}")
            return False